# auth.py - for web application (user-based licensing)
import hashlib
from database import DatabaseManager

class AuthManager:
    def __init__(self, db_manager):
        self.db = db_manager
        # Default admin is now created in DatabaseManager.init_database()
        # So we don't need to call create_default_admin() here anymore

    def authenticate_user(self, username, password):
        hashed_password = hashlib.sha256(password.encode()).hexdigest()
        result = self.db.execute_query(
            "SELECT * FROM users WHERE username = ? AND password = ?",
            (username, hashed_password)
        )
        return result[0] if result else None  # Returns full user row (including activation/trial info)