# utils/helpers.py
from datetime import datetime

def calculate_age(birth_year):
    """Calculate age from birth year"""
    try:
        current_year = datetime.now().year
        return current_year - int(birth_year)
    except:
        return 0

def generate_unique_id(prefix):
    """Generate unique ID with prefix"""
    timestamp = datetime.now().strftime('%Y%m%d%H%M%S')
    return f"{prefix}{timestamp}"

def get_next_daily_token(db_manager):
    """Get next daily token number"""
    today = datetime.now().strftime('%Y-%m-%d')
    
    result = db_manager.execute_query("SELECT last_token_number FROM daily_token_counter WHERE date = ?", (today,))
    
    if result:
        new_token = result[0][0] + 1
        db_manager.execute_query("UPDATE daily_token_counter SET last_token_number = ? WHERE date = ?", (new_token, today))
    else:
        new_token = 1
        db_manager.execute_insert("INSERT INTO daily_token_counter (date, last_token_number) VALUES (?, ?)", (today, new_token))
    
    return new_token